import javax.swing.JApplet;
import java.awt.*;

public class Aplet extends JApplet {
  String tekst;
  Font font = null;
  Color color = null;

  public void init() {
    int paramR = 0, paramG = 0, paramB = 0;
    try{
      paramR = Integer.parseInt(getParameter("paramR"));
      paramG = Integer.parseInt(getParameter("paramG"));
      paramB = Integer.parseInt(getParameter("paramB"));
    }
    catch(NumberFormatException e){
      paramR = 0; paramG = 0; paramB = 0;
    }
    color = new Color(paramR, paramG, paramB);

    font = new Font("Arial", Font.BOLD, 20);
    tekst = getParameter("tekst");
    if(tekst == null)
      tekst = "";
  }
  public void paint (Graphics gDC) {
    gDC.setFont(font);
    FontMetrics fm = gDC.getFontMetrics();

    int strWidth = fm.stringWidth(tekst);
    int strHeight = fm.getHeight();

    int x = (getWidth() - strWidth) / 2;
    int y = (getHeight() + strHeight) / 2;

    gDC.clearRect(0, 0, getSize().width, getSize().height);
    gDC.setColor(color);
    gDC.drawString(tekst, x, y);
  }
}
